# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early rounds (1-3): Start with cooperation
    if current_round <= 3:
        return "C"
    
    # Mid rounds (4-7): Analyze opponent's behavior
    elif current_round <= 7:
        if "D" in opp_history:
            return opp_history[-1]  # TFT if opponent ever defected
        else:
            return "C"  # Keep cooperating if opponent is cooperative
    
    # Late rounds (8-10): Adjust based on opponent's behavior
    else:
        if opp_history.count("D") > opp_history.count("C"):
            return "D"  # Defect if opponent tends to defect
        else:
            return "C"  # Cooperate if opponent is mostly cooperative